/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapListCellRenderer;
import filenet.vw.toolkit.design.property.tables.VWSpecificFaultsTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.table.VWSortedComboBoxModel;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.ws.api.WSOperation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWInvokeFaultsPanel
extends JPanel
implements ActionListener,
TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWTableActionListener,
IVWPropertyChangeListener,
IVWMapChangedListener {
    private VWToolbarBorder m_specificFaultsBorder = null;
    private VWTable m_specificFaultsTable = null;
    private VWSpecificFaultsTableModel m_specificFaultsTableModel = null;
    private VWToolbarBorder m_otherFaultsBorder = null;
    private JComboBox m_xmlDataFieldComboBox = null;
    private JComboBox m_submapComboBox = null;
    private JLabel m_spacerLabel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInvokeInstruction m_instructionDef = null;

    public VWInvokeFaultsPanel(JDialog parentDialog, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.createControls();
    }

    public VWInvokeFaultsPanel(Frame parentFrame, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.createControls();
    }

    public void setOperation(WSOperation operation) {
        try {
            this.m_specificFaultsTable.stopEditing();
            this.m_specificFaultsTableModel.reinitialize(this.m_instructionDef, operation);
            JComboBox cbFaults = this.m_specificFaultsTableModel.getFaultComboBox();
            boolean bDisplaySpecificFaults = cbFaults != null && cbFaults.getModel().getSize() > 0;
            this.m_specificFaultsBorder.setVisible(bDisplaySpecificFaults);
            this.m_spacerLabel.setVisible(!bDisplaySpecificFaults);
            if (!bDisplaySpecificFaults && this.m_instructionDef != null) {
                this.m_instructionDef.setFaults(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setInstructionDefinition(VWInvokeInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.setOperation(null);
        this.reinitialize();
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_submapComboBox) {
            this.performOtherFaultsMapAction();
        } else if (src == this.m_xmlDataFieldComboBox) {
            this.performXMLDataFieldAction();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_specificFaultsTable.getSelectedRow()) {
                    this.m_specificFaultsTable.clearSelection();
                }
                this.m_specificFaultsTable.setRowSelectionInterval(nRow, nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_specificFaultsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_specificFaultsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_specificFaultsTable.getSelectedRow();
            if (this.m_specificFaultsTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_specificFaultsTableModel.getRowCount()) - 1) {
                if (nRowIndex > 0) {
                    this.m_specificFaultsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_specificFaultsBorder.getClientPanel(), 1, 1));
                }
                if (nRowIndex < nRowCount - 2) {
                    this.m_specificFaultsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_specificFaultsBorder.getClientPanel(), 1, 2));
                }
                this.m_specificFaultsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_specificFaultsBorder.getClientPanel(), 1, 0x10000000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            if (event.getSource().equals(this.m_specificFaultsBorder)) {
                int nRowIndex = this.m_specificFaultsTable.getSelectedRow();
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_specificFaultsTableModel.delete(nRowIndex);
                        break;
                    }
                    case 1: {
                        this.onUp();
                        break;
                    }
                    case 2: {
                        this.onDown();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_specificFaultsTable == null) break;
                this.m_specificFaultsTable.stopEditing();
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 563: 
            case 564: 
            case 565: {
                this.m_specificFaultsTableModel.getXMLFieldComboBox();
                this.reinitialize();
            }
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: 
            case 517: 
            case 519: {
                this.m_specificFaultsTableModel.getMapComboBox();
                this.reinitialize();
            }
        }
    }

    protected void reinitialize() {
        this.initXMLDataFieldComboBox();
        this.initSubMapComboBox();
        this.m_xmlDataFieldComboBox.removeActionListener(this);
        this.m_submapComboBox.removeActionListener(this);
        try {
            VWFaultDefinition fault = null;
            if (this.m_instructionDef != null) {
                fault = this.m_instructionDef.getCatchAllFault();
            }
            if (fault != null && fault.getFaultMessage() != null) {
                this.m_xmlDataFieldComboBox.setSelectedItem(fault.getFaultMessage());
            } else {
                this.m_xmlDataFieldComboBox.setSelectedIndex(0);
            }
            if (fault != null && fault.getFaultMapName() != null) {
                this.m_submapComboBox.getModel().setSelectedItem(fault.getFaultMapName());
            } else {
                this.m_submapComboBox.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_xmlDataFieldComboBox.addActionListener(this);
        this.m_submapComboBox.addActionListener(this);
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 0, 5);
            this.m_specificFaultsBorder = new VWToolbarBorder(VWResource.s_specificFaults, 0x10000003);
            this.m_specificFaultsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_specificFaultsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_specificFaultsBorder.addToolbarBorderActionNotifier(this);
            JPanel specificFaultsPanel = this.m_specificFaultsBorder.getClientPanel();
            specificFaultsPanel.setLayout(new BorderLayout());
            this.m_specificFaultsTableModel = new VWSpecificFaultsTableModel(this.m_authPropertyData);
            this.m_specificFaultsTableModel.addTableModelListener(this);
            this.m_specificFaultsTable = new VWTable(this.m_specificFaultsTableModel);
            this.m_specificFaultsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_specificFaultsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_specificFaultsTable.getSelectionModel().addListSelectionListener(this);
            specificFaultsPanel.add(new JScrollPane(this.m_specificFaultsTable));
            this.add((Component)this.m_specificFaultsBorder, gbCons);
            TableColumn tc = null;
            tc = this.m_specificFaultsTable.getColumnModel().getColumn(0);
            if (tc != null) {
                tc.setCellEditor(new DefaultCellEditor(this.m_specificFaultsTableModel.getFaultComboBox()));
                tc.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            if ((tc = this.m_specificFaultsTable.getColumnModel().getColumn(1)) != null) {
                tc.setCellEditor(new DefaultCellEditor(this.m_specificFaultsTableModel.getXMLFieldComboBox()));
                tc.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            if ((tc = this.m_specificFaultsTable.getColumnModel().getColumn(2)) != null) {
                tc.setCellEditor(new DefaultCellEditor(this.m_specificFaultsTableModel.getMapComboBox()));
                tc.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.createOtherFaultsPanel();
            this.add((Component)this.m_otherFaultsBorder, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_spacerLabel = new JLabel();
            this.add((Component)this.m_spacerLabel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    private void createOtherFaultsPanel() {
        this.m_otherFaultsBorder = new VWToolbarBorder(VWResource.s_otherFaults);
        JPanel otherFaultsPanel = this.m_otherFaultsBorder.getClientPanel();
        otherFaultsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(4, 0, 0, 0);
        otherFaultsPanel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_stringField)), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.insets = new Insets(2, 8, 0, 0);
        this.m_xmlDataFieldComboBox = new JComboBox(new VWSortedComboBoxModel());
        this.m_xmlDataFieldComboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_xmlDataFieldComboBox.setEditable(true);
        this.m_xmlDataFieldComboBox.addActionListener(this);
        otherFaultsPanel.add((Component)this.m_xmlDataFieldComboBox, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(2, 0, 0, 0);
        otherFaultsPanel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_submap)), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.insets = new Insets(0, 8, 0, 0);
        this.m_submapComboBox = new JComboBox();
        this.m_submapComboBox.setRenderer(new VWMapListCellRenderer(this.m_authPropertyData));
        this.m_submapComboBox.addActionListener(this);
        otherFaultsPanel.add((Component)this.m_submapComboBox, gbCons);
    }

    private void initXMLDataFieldComboBox() {
        String xmlDataField = null;
        this.m_xmlDataFieldComboBox.removeActionListener(this);
        try {
            VWSortedComboBoxModel model;
            VWFaultDefinition fault;
            if (this.m_instructionDef != null && (fault = this.m_instructionDef.getCatchAllFault()) != null) {
                xmlDataField = fault.getFaultMessage();
            }
            if ((model = (VWSortedComboBoxModel)this.m_xmlDataFieldComboBox.getModel()) != null) {
                int fieldCount;
                boolean bFound = false;
                model.removeAllElements();
                model.addElement(VWResource.s_noneItemStr);
                VWFieldDefinition[] fieldDefs = this.m_authPropertyData.getFields();
                if (fieldDefs != null && (fieldCount = fieldDefs.length) > 0) {
                    for (int i = 0; i < fieldCount; ++i) {
                        VWFieldDefinition fieldDef = fieldDefs[i];
                        String fieldName = fieldDef.getName();
                        if (fieldDef.getFieldType() == 128 || fieldDef.getFieldType() == 2) {
                            model.addElement(fieldName);
                        }
                        if (bFound || xmlDataField == null || VWStringUtils.compare(fieldName, xmlDataField) != 0) continue;
                        bFound = true;
                    }
                }
                if (!bFound && xmlDataField != null && xmlDataField.length() > 0) {
                    model.addElement(xmlDataField);
                }
                model.sort(VWResource.s_noneItemStr);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_xmlDataFieldComboBox.addActionListener(this);
    }

    private void initSubMapComboBox() {
        Object[] mapNames = null;
        Vector<String> mapNamesVec = new Vector<String>();
        this.m_submapComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>();
                cbModel.addElement(VWResource.s_noneItemStr);
                cbModel.addElement("Workflow");
                cbModel.addElement("Malfunction");
                cbModel.addElement("Terminate");
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null) {
                    int len = mapDefs.length;
                    for (int i = 0; i < len; ++i) {
                        String mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare(mapName, "Workflow") == 0 || VWStringUtils.compare(mapName, "Malfunction") == 0 || VWStringUtils.compare(mapName, "Terminate") == 0) continue;
                        mapNamesVec.addElement(mapName);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQubbleSort.sort(mapNames);
                    for (int i = 0; i < mapNames.length; ++i) {
                        Object mapName = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                        cbModel.addElement(mapName);
                    }
                }
                this.m_submapComboBox.setModel(cbModel);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_submapComboBox.addActionListener(this);
    }

    private void performXMLDataFieldAction() {
        try {
            if (this.m_instructionDef != null) {
                String xmlDataField = (String)this.m_xmlDataFieldComboBox.getSelectedItem();
                if (VWStringUtils.compare(xmlDataField, VWResource.s_noneItemStr) == 0) {
                    xmlDataField = null;
                }
                this.m_instructionDef.setCatchAllOutput(xmlDataField);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performOtherFaultsMapAction() {
        try {
            String map = (String)this.m_submapComboBox.getSelectedItem();
            if (VWStringUtils.compare(map, VWResource.s_noneItemStr) == 0) {
                map = null;
            }
            if (this.m_instructionDef != null) {
                this.m_instructionDef.setCatchAllMap(map);
            }
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUp() {
        try {
            int nRowIndex = this.m_specificFaultsTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_specificFaultsTableModel.up(nRowIndex);
                this.m_specificFaultsTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDown() {
        try {
            int nRowIndex = this.m_specificFaultsTable.getSelectedRow();
            if (nRowIndex < this.m_specificFaultsTableModel.getRowCount() - 2) {
                this.m_specificFaultsTableModel.down(nRowIndex);
                this.m_specificFaultsTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

